package structure.device;

public abstract class HouseDevice {
	protected String name;
	protected boolean turnedOn;

	public HouseDevice(String name) {
		this.name = name;
	}
	
	public void turnOn() {
		if (!isTurnedOn()) {
			turnedOn = true;
			logTurnOn();
		}
	}

	public void turnOff() {
		if (isTurnedOn()) {
			turnedOn = false;
			logTurnOff();
		}
	}

	protected void logTurnOn() {
		System.out.println(name + " turnOn");
	}

	protected void logTurnOff() {
		System.out.println(name + " turnOff");
	}
	
	public boolean isTurnedOn() {
		return turnedOn;
	}
}
